//Revised: September 20, 2008
//Notes: setTokenCount function did not work properly, after much testing it is now fixed

#include "StringParser.h"
#include "Methods.h"
#include "Vector.cpp"

using namespace std;

StringParser::StringParser(const char * _data, const char _delim) {
	this->_index = 0;
	this->_currentToken = 0;
	this->_delim = _delim;
	if(_data == NULL) {
		this->_data = new char[1];
		this->_data[0] = '\0';
	}
	else {
		this->_data = new char[strlen(_data) + 1];
		strcpy(this->_data, _data);
	}
	setTokenCount();
}

StringParser & StringParser::operator = (const StringParser & sp) {
	if(this != &sp) {
		this->_index = sp._index;
		this->_currentToken = sp._currentToken;
		this->_tokenCount = sp._tokenCount;
		this->_delim = sp._delim;
		data(sp._data);
	}
	return *this;
}

StringParser::StringParser(const StringParser & sp) {
	if(this != &sp) {
		this->_index = sp._index;
		this->_currentToken = sp._currentToken;
		this->_tokenCount = sp._tokenCount;
		this->_delim = sp._delim;
		if(_data== NULL) {
			this->_data = new char[1];
			this->_data[0] = '\0';
		}
		else {
			this->_data = new char[strlen(_data) + 1];
			strcpy(this->_data, _data);
		}
	}
}

StringParser::~StringParser() {}

void StringParser::data(const char * _data) {
	delete [] this->_data;
	
	if(_data== NULL) {
		this->_data = new char[1];
		this->_data[0] = '\0';
	}
	else {
		this->_data = new char[strlen(_data) + 1];
		strcpy(this->_data, _data);
	}
}

char * StringParser::data() const {
	return this->_data;
}

char * StringParser::nextToken() {
	int startIndex = this->_index;
	int endIndex = (int) strlen(this->_data);
	
	for(int i=startIndex;i<(int)strlen(this->_data);i++) {
		if(this->_data[i] == this->_delim) {
			endIndex = i;
			break;
		}
	}
	
	this->_currentToken++;
	this->_index = endIndex + 1;
	return strsub(this->_data, startIndex, endIndex-1);
}

bool StringParser::hasMoreTokens() const {
	return this->_currentToken < this->_tokenCount;
}

int StringParser::countTokens() const {
	return this->_tokenCount;
}

void StringParser::setTokenCount() {
	this->_tokenCount = 0;

	int start = -1, end = 0;
	int length = (int) strlen(this->_data);

	if( length == 0 ) {
		return;
	}
	
	for(int i=0;i<length;i++) {
		if(this->_data[i] == this->_delim) {
			start = end;
			end = i;
			if( (start == 0 &&
				  (end - start > 0 && this->_data[0] != this->_delim) ||
				  (length > 1 && end - start > 1 && this->_data[0] == this->_delim && this->_data[1] != this->_delim ) ) ||
			    (start > 0 && end - start > 1) ) {
				this->_tokenCount++;
			}
		}
	}
	
	if(start == -1) {
		if( length > 0 ) {
			this->_tokenCount = 1;
		}
	}
	else {
		start = end;
		end = length - 1;
		if(end-start > 0) {
			this->_tokenCount++;
		}
	}
}

bool StringParser::operator == (const StringParser & sp) const {
	return strcmp(this->_data, sp._data) == 0;
}

bool StringParser::operator != (const StringParser & sp) const {
	return !operator == (sp);
}

void StringParser::printOn(ostream & o) const {
	o << _data;
}

ostream & operator << (ostream & o, const StringParser & sp) {
     sp.printOn(o);
     return o;
}
